#include <stdio.h>
#include <assert.h>
#ifdef _WIN32
#include <windows.h>
#else
#include <dlfcn.h>
#endif

#if defined _WIN32 || defined __CYGWIN__
  #define DLL_PUBLIC __declspec(dllexport)
#else
  #if defined __GNUC__
    #define DLL_PUBLIC __attribute__ ((visibility("default")))
  #else
    #pragma message ("Compiler does not support symbol visibility.")
    #define DLL_PUBLIC
  #endif
#endif

typedef int (*fptr) (void);

int DLL_PUBLIC
func_from_executable(void)
{
  return 42;
}

int
main (int argc, char **argv)
{
  int expected, actual;
  fptr importedfunc;

#ifdef _WIN32
  HMODULE h = LoadLibraryA(argv[1]);
#else
  void *h = dlopen(argv[1], RTLD_NOW);
#endif
  assert(h != NULL);

#ifdef _WIN32
  importedfunc = (fptr) GetProcAddress (h, "func");
#else
  importedfunc = (fptr) dlsym(h, "func");
#endif
  assert(importedfunc != NULL);
  assert(importedfunc != func_from_executable);

  actual = (*importedfunc)();
  expected = func_from_executable();
  assert(actual == expected);

#ifdef _WIN32
  FreeLibrary(h);
#else
  dlclose(h);
#endif

  return 0;
}
